document.addEventListener('click', function(e) {
	if (e.target.closest('.collapse__btn')) {
		let el = e.target.closest('.collapse'), elContent = el.querySelector('.collapse__content');

		if (el.dataset.accordion) {
			accordion = document.querySelectorAll(`[data-accordion=${el.dataset.accordion}]`)
		}

		if (el.classList.contains('open')) {
			el.classList.remove('open');
			elContent.style.maxHeight = 0
		} else {
			if (el.dataset.accordion) {
				accordion.forEach(element => {
					element.classList.remove('open');
					element.querySelector('.collapse__content').style.maxHeight = 0;
				});
			}
			el.classList.add('open');
			elContent.style.maxHeight = elContent.scrollHeight + 'px'

			let $elParent = el.closest('.collapse__content') 

			if ($elParent) {
				setTimeout(() => {
					$elParent.style.maxHeight = $elParent.scrollHeight + 'px'
				}, 250)
			}
		}
	}	
})