export function bindTextInputEvents(container) {
	const inputs = container.querySelectorAll('.form-item-wrapper input:not([type="file"])');

	inputs.forEach(el => {
		// Проверка, чтобы не навешивать события повторно
		if (el.dataset.eventsBound) return;

		if (el.value.trim()) {
			el.closest('.form-item-wrapper').classList.add('form-item-wrapper--active');
		}

		el.addEventListener('focus', () => {
			el.closest('.form-item-wrapper').classList.add('form-item-wrapper--active');
		});

		el.addEventListener('blur', () => {
			if (!el.value.trim()) {
				el.closest('.form-item-wrapper').classList.remove('form-item-wrapper--active');
			}
		});

		el.dataset.eventsBound = 'true'; // пометка, что события уже навешаны
	});
}

export function bindFileInputEvents(container) {
	const inputs = container.querySelectorAll('.form-item-wrapper--file input');

	inputs.forEach(el => {
		if (el.dataset.eventsBound) return;

		el.addEventListener('change', () => {
			const placeholder = el.closest('.form-item-wrapper--file').querySelector('.form-item-wrapper__placeholder');
			if (placeholder && el.files.length > 0) {
				placeholder.textContent = el.files[0].name;
			}
		});

		el.dataset.eventsBound = 'true';
	});
}


export function bindSelectEvents(container) {
	const selects = container.querySelectorAll('.form-item-wrapper select');

	selects.forEach(el => {
		if (el.dataset.eventsBound) return;

		el.dataset.selectOpen = 'false';

		if (el.value.trim()) {
			el.closest('.form-item-wrapper').classList.add('form-item-wrapper--active');
		}

		el.addEventListener('click', () => {
			const wrapper = el.closest('.form-item-wrapper');
			const isOpen = el.dataset.selectOpen === 'true';

			if (isOpen) {
				wrapper.classList.remove('form-item-wrapper--open');
				el.dataset.selectOpen = 'false';

				if (!el.value.trim()) {
					wrapper.classList.remove('form-item-wrapper--active');
				}
			}

			else {
				wrapper.classList.add('form-item-wrapper--open');
				wrapper.classList.add('form-item-wrapper--active');
				el.dataset.selectOpen = 'true';
			}
		});

		el.addEventListener('blur', () => {
			const wrapper = el.closest('.form-item-wrapper');
			wrapper.classList.remove('form-item-wrapper--open');
			el.dataset.selectOpen = 'false';

			if (!el.value.trim()) {
				wrapper.classList.remove('form-item-wrapper--active');
			}
		});

		el.dataset.eventsBound = 'true';
	});
}

bindTextInputEvents(document);
bindFileInputEvents(document);
bindSelectEvents(document);


let searchWithResults = document.querySelectorAll('.search-to-open__input');

if (searchWithResults.length) {
	searchWithResults.forEach(el => {
		let searchContainer = el.closest('.search-to-open');
		let searchResults = searchContainer.querySelector('.search-to-open__results');
		let items = Array.from(searchResults.children);

		el.addEventListener('input', function () {
			const query = el.value.trim().toLowerCase();

			if (query.length > 2) {
				let hasMatch = false;

				items.forEach(item => {
					const text = item.textContent.toLowerCase();

					if (text.includes(query)) {
						item.style.display = '';
						hasMatch = true;
					} 
					
					else {
						item.style.display = 'none';
					}
				});

				if (hasMatch) {
					showResults(searchResults);
				} 
				
				else {
					hideResults(searchResults);
				}
			} 
			
			else {
				items.forEach(item => item.style.display = '');
				hideResults(searchResults);
			}
		});

		el.addEventListener('blur', function () {
			hideResults(searchResults);
		});
	});

	function showResults(results) {
		results.style.height = results.scrollHeight + 'px';
	}

	function hideResults(results) {
		results.style.height = '';
	}
}
